
#include    "button.h"

uint8 ButtonDebounceTime;
uint8 ButtonRepeatTime;
uint8 ButtonCurrentStatus;
uint8 ButtonPreviousStatus;
/*---------------------------------------------------------------------------*/
/*																			 */
/*---------------------------------------------------------------------------*/
void BTN_InterfaceConfigure(void)
{
   /* configure button as GPIO  */
   _pas0 &= 0x33;
   _pas1 &= 0x0F;
	
	_pac |= 0xCA;
	_papu |= 0xCA;
	_pawu |= 0xCA;
	
 	ButtonCurrentStatus = 0;
	ButtonPreviousStatus = 0;
   ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
}
/*---------------------------------------------------------------------------*/
/*																			 */
/*---------------------------------------------------------------------------*/
uint8 BTN_ScanStatus(void)
{
   byte_t x;

   x.value = 0x00;
   if(!KEY1_IN)  x.bits.b0 = 1;
   if(!KEY2_IN)  x.bits.b1 = 1;
   if(!KEY3_IN)  x.bits.b2 = 1;
   if(!KEY4_IN)  x.bits.b3 = 1;

   if(x.value ^ ButtonCurrentStatus)
   {
      ButtonCurrentStatus = x.value;
      ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
      ButtonRepeatTime = BUTTON_REPEAT1_DURATION;
      x.value = FALSE;
   }
   else
   {
   	x.value = FALSE;
      if(--ButtonDebounceTime == 0)
      {
         ButtonDebounceTime = BUTTON_CONSISTENCY_DURATION;
			if(ButtonCurrentStatus ^ ButtonPreviousStatus)
			{
				ButtonPreviousStatus = ButtonCurrentStatus;
            ButtonRepeatTime--;
      		x.value = TRUE;
			}
         else
         {
            if((ButtonPreviousStatus != 0) && (--ButtonRepeatTime == 0))
            {
               ButtonRepeatTime = BUTTON_REPEAT2_DURATION;
               x.value = TRUE;
            }
         }
      }
   }
   return(x.value);
}
/*---------------------------------------------------------------------------*/
/*																			 */
/*---------------------------------------------------------------------------*/
uint8 BTN_GetStatus(void)
{
	return(ButtonPreviousStatus);
}
